# Think-Cell Landing Page

A responsive, accessible, and performant landing page built with Tailwind CSS, Vite, and vanilla JavaScript, based on a Figma design. This project features a hero section, modular navigation (meta and main, including a static language selector and search with shortcut), an interactive video modal, and a dynamic footer. It’s optimized for SEO, security, and modern development workflows.

## Features

- **Responsive Design:** Pixel-perfect at 1440px, tested at 320px (mobile), 768px (tablet), and 1440px (desktop) viewports using Tailwind’s responsive utilities.
- **Accessibility:** Semantic HTML, ARIA attributes, focus trapping, keyboard navigation (e.g., `Cmd + K` search, Escape to close modals), and screen reader support.
- **Interactivity:** Static language selector, search with `Cmd + K` shortcut, and a video modal with lazy-loaded YouTube embed.
- **SEO Optimization:** Meta tags, canonical link, Open Graph data, and JSON-LD structured data for search engine visibility.
- **Performance:** Lazy-loaded images and iframes, preloaded fonts, critical CSS to prevent FOUC, and a fade-in animation for smooth loading.
- **Modularity:** Component-based architecture with `ComponentLoader` for reusability and extensibility (supports hypothetical pages).
- **Security:** CSP headers, `X-Content-Type-Options`, and `X-XSS-Protection` for safe rendering.
- **Testing:** Unit tests with Jest for key utilities (`ComponentLoader`, `domUtils`, `focusTrap`).

## Project Structure

```
thinkcell-landing-page/
├── __tests__/
│   ├── ComponentLoader.test.js
│   ├── domUtils.test.js
│   └── focusTrap.test.js
├── src/
│   ├── components/
│   │   ├── ComponentLoader.js
│   │   ├── Footer.js
│   │   ├── Hero.js
│   │   ├── Navigation.js
│   │   └── VideoModal.js
│   ├── styles/
│   │   ├── fonts.css
│   │   └── main.css
│   ├── utils/
│   │   ├── domUtils.js
│   │   ├── EventManager.js
│   │   └── focusTrap.js
│   └── main.js
├── assets/
│   ├── fonts/
│   ├── icons/
│   ├── images/
│   └── favicon.ico
├── .babelrc
├── .eslintrc.js
├── .gitignore
├── .prettierrc
├── index.html
├── jest.config.js
├── package.json
├── postcss.config.js
├── README.md
├── tailwind.config.js
├── vite.config.js
└── dist/ (generated via build)
```

## Setup

1. **Clone or Extract the Project:**
   ```bash
   extract the project folder to your desired location
   ```

2. **Install Dependencies:**
   ```bash
   npm install
   ```

3. **Run Locally:**
   ```bash
   npm run dev
   ```
   Open your browser to `http://localhost:5173`.

4. **Build for Production:**
   ```bash
   npm run build
   ```
   Preview the build:
   ```bash
   npm run preview
   ```

## Tools Used

- **Vite:** Fast build tool and development server.
- **Tailwind CSS:** Utility-first styling with a custom configuration.
- **Vanilla JavaScript:** Lightweight interactivity with no framework dependencies.
- **Jest:** Unit testing framework for utilities.
- **ESLint & Prettier:** Code linting and formatting for consistency.
- **PostCSS:** Processes Tailwind with Autoprefixer.

## Development Workflow

- **Linting:** `npm run lint` to check code quality.
- **Formatting:** `npm run format` to apply Prettier rules.
- **Testing:** `npm run test` to run Jest unit tests.

## Accessibility

- **ARIA Compliance:** Navigation, modals, and dropdowns use ARIA attributes (e.g., `aria-expanded`, `aria-hidden`).
- **Keyboard Navigation:** Full support for Tab, Shift+Tab, Escape, and `Cmd + K` shortcuts.
- **Focus Management:** Modals and overlays trap focus and restore it on close.

## Performance

- **Lazy Loading:** Applied to images (`loading="lazy"`) and the video iframe.
- **Font Optimization:** Preloaded WOFF2 fonts with `font-display: swap`.
- **Critical CSS:** Inline styles in `index.html` prevent flash of unstyled content (FOUC).
- **Build Optimization:** Vite with Terser minification and console stripping.

## Security

- **Headers:** CSP restricts sources, `X-Content-Type-Options: nosniff`, and `X-XSS-Protection` enhance safety.
- **Iframe Security:** YouTube embed uses modest branding and restricted permissions.

## Testing

- **Unit Tests:** Jest tests cover `ComponentLoader`, `domUtils`, and `focusTrap` for reliability.
- **Responsive Testing:** Manually verified at 320px, 768px, and 1440px using Chrome DevTools to ensure pixel-perfect rendering across devices.

## Additional Notes

- **Production Readiness:** The build process (`npm run build`) outputs a minified, optimized `dist/` folder ready for deployment.
- **Extensibility:** The `ComponentLoader` and routing in `main.js` support additional pages (e.g., `#product`) as a proof of concept.
- **No Dark Mode:** Omitted per Figma design fidelity, as noted.
