import { jest } from '@jest/globals';
import { ComponentLoader } from '/src/components/ComponentLoader.js';

describe('ComponentLoader', () => {
  let loader;

  beforeEach(() => {
    loader = new ComponentLoader();
  });

  test('registers a component', () => {
    const component = { render: jest.fn() };
    loader.register('testComponent', component);
    expect(loader.components.testComponent).toEqual({
      render: component.render,
      init: expect.any(Function),
      cleanup: expect.any(Function),
    });
  });

  test('renders a registered component', () => {
    const renderFn = jest.fn();
    loader.register('testComponent', { render: renderFn });
    const target = document.createElement('div');
    target.id = 'test-target';
    document.body.appendChild(target);
    loader.render('testComponent', 'test-target');
    expect(renderFn).toHaveBeenCalledWith(target);
  });

  test('calls cleanup before re-rendering', () => {
    const cleanupFn = jest.fn();
    const renderFn = jest.fn(() => cleanupFn); // Return cleanupFn
    loader.register('testComponent', { render: renderFn, cleanup: cleanupFn });
    const target = document.createElement('div');
    target.id = 'test-target';
    document.body.appendChild(target);
    loader.render('testComponent', 'test-target');
    loader.render('testComponent', 'test-target');
    expect(cleanupFn).toHaveBeenCalledTimes(1);
    expect(renderFn).toHaveBeenCalledTimes(2);
  });
});