import { toggleDropdown } from '/src/utils/domUtils.js';

describe('domUtils', () => {
  let container, button;

  beforeEach(() => {
    container = document.createElement('div');
    container.innerHTML = `
      <button id="trigger">Toggle</button>
      <div id="dropdown" class="scale-0 opacity-0 hidden"></div>
    `;
    document.body.appendChild(container);
    button = container.querySelector('#trigger');
  });

  afterEach(() => {
    document.body.removeChild(container);
  });

  test('toggleDropdown opens and closes dropdown', () => {
    const dropdown = container.querySelector('#dropdown');

    toggleDropdown({ id: 'dropdown', trigger: button, focusId: null });
    expect(dropdown.classList.contains('scale-0')).toBe(false);
    expect(dropdown.classList.contains('opacity-100')).toBe(true);
    expect(button.getAttribute('aria-expanded')).toBe('true');

    toggleDropdown({ id: 'dropdown', trigger: button, focusId: null });
    expect(dropdown.classList.contains('scale-0')).toBe(true);
    expect(dropdown.classList.contains('opacity-0')).toBe(true);
    expect(button.getAttribute('aria-expanded')).toBe('false');
  });
});