import { trapFocus } from '/src/utils/focusTrap.js';

describe('focusTrap', () => {
  let container;

  beforeEach(() => {
    container = document.createElement('div');
    container.innerHTML = `
      <button id="first">First</button>
      <a href="#" id="middle">Middle</a>
      <button id="last">Last</button>
    `;
    document.body.appendChild(container);
  });

  afterEach(() => {
    document.body.removeChild(container);
  });

  test('traps focus within container', () => {
    const first = container.querySelector('#first');
    const last = container.querySelector('#last');
    const cleanup = trapFocus(container);

    first.focus();
    expect(document.activeElement).toBe(first);

    const tabEvent = new KeyboardEvent('keydown', { key: 'Tab', shiftKey: true });
    container.dispatchEvent(tabEvent);
    expect(document.activeElement).toBe(last);

    cleanup();
  });
});