/**
 * Renders the footer into the provided target element.
 * @param {HTMLElement} target - The element to render the footer into.
 */
export function renderFooter(target) {
  if (!target) return;
  while (target.firstChild) {
    target.removeChild(target.firstChild);
  }
  const footerDiv = document.createElement('div');
  footerDiv.className = 'max-w-7xl mx-auto px-4 py-8 text-sm text-gray-500';
  const p = document.createElement('p');
  p.textContent = `© ${new Date().getFullYear()} Think-Cell Demo. All rights reserved.`;
  footerDiv.appendChild(p);
  target.appendChild(footerDiv);
}