/**
 * Renders the hero section into the provided target element.
 * @param {HTMLElement} target - The element to render the hero section into.
 * @param {Object} [content] - Optional content object to override defaults.
 */
export function renderHero(target, content = {}) {
  if (!target) return;
  target.innerHTML = ''; // Clear existing content

  // Default content (can be overridden)
  const defaultContent = {
    title: 'Powerpoint-Diagramme.<br>Wie sie sein sollten.',
    description: 'Mit think-cell erstellen Sie beeindruckende Diagramme in wenigen Minuten, verbessern Ihr Folien-Layout und automatisieren Ihre regelmäßige Berichte.',
    ctaText: 'Jetzt kostenlos testen',
    ctaHref: '#',
  };
  const { title, description, ctaText, ctaHref } = { ...defaultContent, ...content };

  // Left Column
  const leftDiv = document.createElement('div');
  leftDiv.className = 'md:col-span-6 flex flex-col justify-center';

  const titleEl = document.createElement('h1');
  titleEl.className = 'hero-title';
  titleEl.innerHTML = title;
  leftDiv.appendChild(titleEl);

  const desc = document.createElement('p');
  desc.className = 'hero-description';
  desc.textContent = description;
  leftDiv.appendChild(desc);

  const ctaDiv = document.createElement('div');
  ctaDiv.className = 'flex justify-start';
  const ctaLink = document.createElement('a');
  ctaLink.href = ctaHref;
  ctaLink.className = 'btn-cta-mobile md:btn-cta';
  ctaLink.textContent = ctaText;
  ctaDiv.appendChild(ctaLink);
  leftDiv.appendChild(ctaDiv);

  // Right Column
  const rightDiv = document.createElement('div');
  rightDiv.className = 'md:col-span-6 relative flex items-center justify-center bg-video bg-no-repeat bg-center bg-contain';

  const picture = document.createElement('picture');
  const source = document.createElement('source');
  source.srcset = '/assets/images/video-thumbnail.webp';
  source.type = 'image/webp';
  picture.appendChild(source);

  const img = document.createElement('img');
  img.src = '/assets/images/video-thumbnail.png';
  img.alt = 'Think-Cell Video Thumbnail';
  img.className = 'w-full h-auto object-cover';
  img.loading = 'lazy';
  img.width = 800;
  img.height = 450;
  picture.appendChild(img);
  rightDiv.appendChild(picture);

  const videoBtn = document.createElement('button');
  videoBtn.dataset.action = 'open-video';
  videoBtn.className = 'absolute inset-0 flex items-center justify-center focus:outline-none';
  videoBtn.setAttribute('aria-label', 'Produktvideo abspielen');

  const span = document.createElement('span');
  span.className = 'absolute w-20 h-20 rounded-full bg-brandGreen/30 animate-ping';
  videoBtn.appendChild(span);

  const playImg = document.createElement('img');
  playImg.src = '/assets/icons/play.svg';
  playImg.alt = 'Play Video';
  playImg.className = 'relative z-10 w-auto h-auto';
  videoBtn.appendChild(playImg);
  rightDiv.appendChild(videoBtn);

  // Append columns to the target
  target.appendChild(leftDiv);
  target.appendChild(rightDiv);
}