/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './index.html',
    './src/**/*.{html,js}',
  ],
  theme: {
    extend: {
      fontFamily: {
        futura: ['Futura PT', 'sans-serif'],
      },
      colors: {
        brandGreen: '#378F53',
        brandGray: '#F8F8F8',
      },
      fontSize: {
        nav: '1.25rem', // 20px
        'hero-title': ['3rem', { lineHeight: '3.5rem' }], // 48px
        'hero-description': ['1.375rem', { lineHeight: '2.25rem' }], // 22px
      },
      lineHeight: {
        nav: '1.625rem', // 26px
      },
      letterSpacing: {
        nav: '0.2px',
      },
      screens: {
        'xl': '1440px', // Extends defaults for pixel-perfect 1440px
      },
      width: {
        '12': '3rem', // 48px
        '10': '2.5rem', // 40px
      },
      height: {
        '3.5': '0.875rem', // 14px
        '4': '1rem', // 16px
        '2.5': '0.625rem', // 10px
      },
    },
  },
  plugins: [],
};